<?php
/******************************************************************************
Etano
===============================================================================
File:                       message_read.php
$Revision: 679 $
Software by:                DateMill (http://www.datemill.com)
Copyright by:               DateMill (http://www.datemill.com)
Support at:                 http://www.datemill.com/forum
*******************************************************************************
* See the "docs/licenses/etano.txt" file for license.                         *
******************************************************************************/

require 'includes/common.inc.php';
require _BASEPATH_.'/includes/user_functions.inc.php';
require _BASEPATH_.'/includes/tables/user_inbox.inc.php';
require _BASEPATH_.'/skins_site/'.get_my_skin().'/lang/mailbox.inc.php';
check_login_member('auth');	// allow every member for now. Finer checking is made below

$tpl=new phemplate(_BASEPATH_.'/skins_site/'.get_my_skin().'/','remove_nonjs');

$content='';

if (!empty($_GET['mail_id']) && isset($_GET['fid'])) {

	$output=$user_inbox_default['defaults'];
	$output['mail_id']=(int)$_GET['mail_id'];
	$output['return2']=sanitize_and_format_gpc($_GET,'return',TYPE_STRING,$__field2format[FIELD_TEXTFIELD],'');
	$output['return']=rawurlencode($output['return2']);

	$my_folders=array(
		FOLDER_INBOX=>$GLOBALS['_lang'][110],
		FOLDER_OUTBOX=>$GLOBALS['_lang'][111],
		FOLDER_TRASH=>$GLOBALS['_lang'][112],
		FOLDER_SPAMBOX=>$GLOBALS['_lang'][113]
	);
	
	// Get User Personal Folders
	$query="SELECT `folder_id`,`folder` FROM `{$dbtable_prefix}user_folders` WHERE `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
	if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
	while ($rsrow=mysql_fetch_row($res)) {
		$my_folders[$rsrow[0]]=$rsrow[1];
	}

	// Assign folder
	$output['fid']=FOLDER_INBOX;
	if (!empty($_GET['fid']) && isset($my_folders[$_GET['fid']])) {
		$output['fid']=(int)$_GET['fid'];
	}
	
	// Move to folder options
	$moveto_folders=$my_folders;
	unset($moveto_folders[FOLDER_SPAMBOX]);
	unset($moveto_folders[FOLDER_OUTBOX]);
	unset($moveto_folders[FOLDER_TRASH]);
	unset($moveto_folders[$output['fid']]);
	$output['moveto_folders']=vector2options($moveto_folders);
	
	
	$my_folders=sanitize_and_format($my_folders,TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);
	$mailbox_table='inbox';
	$where="a.`fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."' AND a.`mail_id`=".$output['mail_id'];

	// Assign folder dependant stuff
	switch ($output['fid']) {
		case FOLDER_INBOX:
			$tpl->set_var('spam_controls',true);
			break;

		case FOLDER_TRASH:
			break;

		case FOLDER_OUTBOX:
			$mailbox_table='outbox';
			$tpl->set_var('is_outbox',true);
			break;

		case FOLDER_SPAMBOX:
			$mailbox_table='spambox';
			break;

		default:
			$tpl->set_var('spam_controls',true);
			break;

	}
	
	// Get message content and sender profile
	$query="SELECT a.*,UNIX_TIMESTAMP(a.`date_sent`) as `date_sent`,a.`date_sent` as `date_sent_raw`,b.`fk_user_id` as `other_id`,b.`_photo` as `photo` FROM `{$dbtable_prefix}user_{$mailbox_table}` a LEFT JOIN `{$dbtable_prefix}user_profiles` b ON a.`fk_user_id_other`=b.`fk_user_id` WHERE $where LIMIT 1";
	if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
	if (mysql_num_rows($res)) {
		$output=array_merge($output,mysql_fetch_assoc($res));
		$output['date_sent']=strftime($_SESSION[_LICENSE_KEY_]['user']['prefs']['datetime_format'],$output['date_sent']+$_SESSION[_LICENSE_KEY_]['user']['prefs']['time_offset']);
		// it was saved sanitized so no need to resanitize here
		// $output['subject']=sanitize_and_format($output['subject'],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);

		switch ($output['message_type']) {

			case MESS_MESS:
				// it was saved sanitized so no need to resanitize here
				// $output['message_body']=sanitize_and_format($output['message_body'],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);
				check_login_member('message_read');
				$output['message_body']=nl2br($output['message_body']);
				break;

			case MESS_FLIRT:
				check_login_member('flirt_read');
				break;

			case MESS_SYSTEM:
				if (empty($output['_user_other'])) {
					$output['_user_other']=$GLOBALS['_lang'][135];
				}
				if (empty($output['photo'])) {
					$output['photo']='admin.gif';
				}
				$tpl->set_var('spam_controls',false);
			break;

		}
		
		$output['message_body']=text2smilies(bbcode2html($output['message_body']));
		if (empty($output['photo'])) {
			$output['photo']='no_photo.gif';
		}
		if (empty($output['other_id'])) {
			unset($output['other_id']);
		} else {
			require _BASEPATH_.'/includes/network_functions.inc.php';
			if (is_network_member($_SESSION[_LICENSE_KEY_]['user']['user_id'],$output['other_id'],NET_BLOCK)) {
				$output['is_blocked']=true;
			}
			$output['net_block']=NET_BLOCK;
		}
		$output['mailbox_name']=$my_folders[$output['fid']];
		
		
		// -----------------------------------------------------------
		// Message History Mod
		// -----------------------------------------------------------
		$loop=array();
		
		// Only show the message history for normal messages (Inbox, Outbox and Personal Folders messages)
		if ($output['fid'] != FOLDER_TRASH && $output['fid'] != FOLDER_SPAMBOX && $output['message_type'] != MESS_SYSTEM){
			
			$tpl->set_var('show_history',TRUE);
			
			if(isset($output['other_id']) && !empty($output['other_id'])){
				
				$photoRes=array('user_photo' => 'no_photo.gif',	'other_photo' => 'no_photo.gif');
	
				$userPhoto="SELECT a.`_photo` as `user_photo`,b.`_photo` as `other_photo` FROM `{$dbtable_prefix}user_profiles` a, `{$dbtable_prefix}user_profiles` b WHERE a.`fk_user_id` = ".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND b.`fk_user_id` = ".$output['other_id']."";
				if (!($res=@mysql_query($userPhoto))) {trigger_error(mysql_error(),E_USER_ERROR);}
				if (mysql_num_rows($res)) {
					$photoRes2=mysql_fetch_assoc($res);
					if(!empty($photoRes2['user_photo']) && is_file(_PHOTOPATH_.'/t1/'.$photoRes2['user_photo'])){
						$photoRes['user_photo']=$photoRes2['user_photo'];
					}
					if(!empty($photoRes2['other_photo']) && is_file(_PHOTOPATH_.'/t1/'.$photoRes2['other_photo'])){
						$photoRes['other_photo']=$photoRes2['other_photo'];
					}
				}

				$query="
					SELECT `mail_id`,`is_read`,`fk_user_id_other` as `sender`,`_user_other` as `user_other`,`subject`,`message_body`,UNIX_TIMESTAMP(`date_sent`) as `date_sent`,`message_type` FROM {$dbtable_prefix}user_inbox WHERE `fk_user_id`=".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND `fk_user_id_other`=".$output['other_id']." AND `del` = 0 AND `date_sent` < '".$output['date_sent_raw']."' 
					UNION ALL 
					SELECT `mail_id`,`is_read`,`fk_user_id` as `sender`,`_user_other` as `user_other`,`subject`,`message_body`,UNIX_TIMESTAMP(`date_sent`) as `date_sent`,`message_type` FROM {$dbtable_prefix}user_outbox WHERE `fk_user_id`=".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND `fk_user_id_other`=".$output['other_id']." AND `date_sent` < '".$output['date_sent_raw']."' 
					ORDER BY `date_sent` DESC LIMIT 5";
				if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
				while ($rsrow=mysql_fetch_assoc($res)) {
					
					$rsrow['date_sent']=strftime($_SESSION[_LICENSE_KEY_]['user']['prefs']['datetime_format'],$rsrow['date_sent']+$_SESSION[_LICENSE_KEY_]['user']['prefs']['time_offset']);
					$rsrow['allow_reply']=true;
					if($rsrow['sender'] == $_SESSION[_LICENSE_KEY_]['user']['user_id']){
						$msg_folder='OUTBOX';
						$rsrow['allow_reply']=false;
						$rsrow['user_other']='You';
						$rsrow['is_sender']=true;
						$rsrow['photo']=$photoRes['user_photo'];
						$rsrow['fid']=FOLDER_OUTBOX;
					} else {
						$msg_folder='INBOX';
						if ($rsrow['message_type']==MESS_SYSTEM && empty($rsrow['user_other'])) {
							$rsrow['user_other']=$GLOBALS['_lang'][135];
						} else {
							$rsrow['allow_reply']=true;
							$rsrow['user_other']=get_user_by_userid($rsrow['sender']);
							$rsrow['is_sender']=false;
						}
						$rsrow['fid']=FOLDER_INBOX;
						$rsrow['photo']=$photoRes['other_photo'];
					}
					
					$rsrow['message_body']=text2smilies(bbcode2html($rsrow['message_body']));
					
					// Mark unread messages as read if unread messages are loaded
					// happens when a user selects a newer message from the same user
					if($rsrow['is_read'] == 0){
						if($msg_folder == 'INBOX'){
							$query2="UPDATE `{$dbtable_prefix}user_inbox` SET `is_read`=1 WHERE `mail_id`=".$rsrow['mail_id']." AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
							if (!($res2=@mysql_query($query2))) {trigger_error(mysql_error(),E_USER_ERROR);}
						}elseif($msg_folder='OUTBOX'){
							$query2="UPDATE `{$dbtable_prefix}user_outbox` SET `is_read`=1 WHERE `mail_id`=".$rsrow['mail_id']." AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
							if (!($res2=@mysql_query($query2))) {trigger_error(mysql_error(),E_USER_ERROR);}
						}
					}

					if ($rsrow['date_sent']>$page_last_modified_time) {
						$page_last_modified_time=$rsrow['date_sent'];
					}
					$loop[]=$rsrow;
				}
						
			}

		}else{
			$tpl->set_var('show_history',FALSE);
		}
		
		$tpl->set_loop('loop',$loop);
		
		// -----------------------------------------------------------
		// End Message History
		// -----------------------------------------------------------
		

		$output['return2me']='message_read.php';
		if (!empty($_SERVER['QUERY_STRING'])) {
			$output['return2me'].='?'.$_SERVER['QUERY_STRING'];
		}
		$output['return2me']=rawurlencode($output['return2me']);

		$tpl->set_file('content','message_read.html');
		$tpl->set_var('output',$output);
		$tpl->process('content','content',TPL_LOOP | TPL_NOLOOP | TPL_OPTLOOP | TPL_OPTIONAL);

		if ($output['is_read']==0) {
			$query="UPDATE `{$dbtable_prefix}user_{$mailbox_table}` SET `is_read`=1 WHERE `mail_id`=".$output['mail_id']." AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
			if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
		}
	} else {
		$topass['message']['type']=MESSAGE_ERROR;
		$topass['message']['text']=$GLOBALS['_lang'][5];
		redirect2page('mailbox.php');
	}
} else {
	$topass['message']['type']=MESSAGE_ERROR;
	$topass['message']['text']=$GLOBALS['_lang'][5];
	redirect2page('mailbox.php');
}

$tplvars['title']=$GLOBALS['_lang'][136];
$tplvars['page_title']=$GLOBALS['_lang'][136];
$tplvars['page']='message_read';
$tplvars['css']='message_read.css';
if (is_file('message_read_left.php')) {
	include 'message_read_left.php';
}
include 'frame.php';
